function [PA, PAl, PAr]=cardinalityIT2(A)

%
% [PA, PAl, PAr]=cardinalityIT2(A)
%
% To compute the cardinality of an IT2 FS, which is defined by nine
% parameters (a, b, c, d, e, f, g, i, h) shown in Fig. 1 of Readme.doc. 
%
% D. Wu and J.M. Mendel, "Uncertainty measures for interval type-2 fuzzy
% set," Information Sciences, 177, pp. 5378-5393, 2007.
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Last modified by Dongrui WU (dongruiw@usc.edu), 3/24/2009
%
% A: an IT2 FS represented by 9 parameters.
% PA: average cardinality of A
% PAl: left bound of the cardinality
% PAr: right bound of the cardinality
%

N=100;
Xs=linspace(A(1),A(4),N);
UMF=mg(Xs,A(1:4),[0 1 1 0]);
LMF=mg(Xs,A(5:8),[0 A(9) A(9) 0]);
PAl=sum(LMF)/N;
PAr=sum(UMF)/N;
PA=(PAl+PAr)/2;
